/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSemaphoreImpWin32.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSemaphoreImpWin32_h	// [
#define Included_CSemaphoreImpWin32_h

#include "pgpClassesConfig.h"
#include "CSemaphoreImp.h"

_PGP_BEGIN

// Class CSemaphoreImpWin32

class CSemaphoreImpWin32 : public CSemaphoreImp
{
	friend class CPFLImpFactoryWin32;

private:
	CSemaphoreImpWin32();
	~CSemaphoreImpWin32();

	PGPUInt32	Wait(PGPInt32 msTimeout);
	void		Signal(PGPUInt32 count);

private:
	HANDLE mSemHandle;
};


// Class CSemaphoreImpWin32 member functions

inline 
CSemaphoreImpWin32::CSemaphoreImpWin32()
{
	mSemHandle = CreateSemaphore(NULL, 0, 0x7FFFFFFF, NULL);

	if (IsNull(mSemHandle))
		THROW_ERRORS(kPGPError_SyncObjOpFailed, GetLastError());
}

inline 
CSemaphoreImpWin32::~CSemaphoreImpWin32()
{
	CloseHandle(mSemHandle);
	mSemHandle = NULL;
}

inline 
PGPUInt32 
CSemaphoreImpWin32::Wait(PGPInt32 msTimeout)
{
	if (msTimeout == CSemaphore::InfiniteTimeout)
		msTimeout = INFINITE;

	return WaitForSingleObjectEx(mSemHandle, msTimeout, FALSE);
}

inline 
void 
CSemaphoreImpWin32::Signal(PGPUInt32 count)
{
	ReleaseSemaphore(mSemHandle, count, NULL);
}

_PGP_END

#endif	// ] Included_CSemaphoreImpWin32_h
